/***********************************************************************
*
* lister header file. -- Version 3.0
*
* Copyright (c)
* Apple Computer, Inc.  1988-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
***********************************************************************/

#define productionVersion 1

#define __fmdTool__
#include <fakeModalDialog.h>

#if productionVersion
#define initPtrCheck(x);
#define closePtrCheck();
#define zapLocals();
#define checkForHit();
#endif

extern pascal void	handleKeys();

/**********************************************************************/

/* The ifdef below allows the definitions to be external, except
** for the globals file.  This way, everybody can use lister.h.
*/

#ifdef __globals__
#define cextern
#else
#define cextern extern
#endif

#ifndef __QUICKDRAW__
#include <quickdraw.h>
#endif

#ifndef __PRINT__
#include <print.h>
#endif

#ifndef __GSOS__
#include <gsos.h>
#endif

/********************************************************/

#define MainWindowID	0x1000L
#define AboutWindowID	0x2000L
#define NowPrintingID	0x3000L
#define TabsWindowID	0x4000L

#define ChFont			 5L
#define Header			11L
#define Footer			12L
#define Columns			13L
#define UseBorder		20L
#define TextAsIs		22L
#define HiBitOff		23L
#define HiBitOn			24L
#define ChangeTabs		25L
#define BoxProc			26L

#define TabsOK			1L
#define TabsCancel		2L
#define TabsData		103L
#define TabChr			104L
#define TabsDataText	5L
#define TabChrText		6L
#define MerlinTabs		20L
#define MerlinTabsData	21L

#define PostScriptBegin		190
#define TextIsPostScript	194
#define PostScriptEnd		191

/*******************************************/

#define SHORTINDEX		123

#define AppleMenuID		0x901
#define AboutItem			301

#define FileMenuID		0x902
#define CloseItem			255		/* For DA's */
#define OpenFileItem		401
#define ChoosePrinterItem	402
#define PageSetupItem		403
#define PrintItem			404
#define QuitItem			499

#define EditMenuID		0x903
#define UndoItem			250		/* For DA's */
#define CutItem				251		/* For DA's */
#define CopyItem			252		/* For DA's */
#define PasteItem			253		/* For DA's */
#define ClearItem			254		/* For DA's */

/***********************************************/

extern char		test[80];

#ifndef __file__
extern
#endif
unsigned int	_fileErr;

cextern unsigned int	quitFlag;			/* True when quitting */
cextern WmTaskRec		event;				/* All events are returned here */
cextern WindowPtr		mainWindow, aboutWindow, cancelPrintWindow, tabsWindow;

cextern	char	grayPat[]
#ifdef __globals__
= {
	0xCC, 0xCC, 0x33, 0x33, 0xCC, 0xCC, 0x33, 0x33,
	0xCC, 0xCC, 0x33, 0x33, 0xCC, 0xCC, 0x33, 0x33,
	0xCC, 0xCC, 0x33, 0x33, 0xCC, 0xCC, 0x33, 0x33,
	0xCC, 0xCC, 0x33, 0x33, 0xCC, 0xCC, 0x33, 0x33
}
#endif
;

typedef struct BorderLine {
	unsigned int	used;	/* Defines if the border is to be used or not.	*/
	Rect 			line;	/* A small rect that is used to draw and detect	*/
							/* clicks on the lines representing borders.	*/
} BorderLine;

cextern struct {
	PrRecHndl		prRec;				/* Handle to my Print record					 */
	unsigned int	numCols;			/* Number of columns per page to print			 */
	FontID			theFont;			/* The ID of the font to print in				 */
	unsigned int	postScript;			/* TRUE if printing to PostScript device.		 */
	unsigned int	sideways;			/* TRUE if printing in landscape mode.			 */
	Rect			myPage;				/* Used for page calculations.					 */
	unsigned int	haveHeader;
	unsigned int	haveFooter;
	char			tabsData[42];		/* User inputted tab stop data.					 */
	unsigned int	tabChr;				/* Character (ascii value) to tab on.			 */
	BorderLine		myBorders[8];
} print
#ifdef __globals__
= {
	NULL,								/* prRec				  */
	0,									/* numCols				  */
	{courier, 0, 10},					/* theFont				  */
	0, 0,								/* postScript, sideways	  */
	{0, 0, 0, 0},						/* myPage				  */
	0, 0,								/* haveHeader, haveFooter */
	"\0", 9,							/* tab values			  */
	true,  100, 175, 154, 425,			/* surrounds entire box	  */
	true,  100, 175, 102, 425,			/* top line				  */
	true,  105, 175, 107, 425,			/* under header			  */
	false, 147, 175, 149, 425,			/* above footer			  */
	true,  152, 175, 154, 425,			/* bottom line			  */
	true,  100, 175, 154, 177,			/* left line			  */
	true,  100, 299, 154, 301,			/* center line			  */
	true,  100, 423, 154, 425			/* right line			  */
}
#endif
;


/*********** The following structures and buffers are for file IO.  ***********/

typedef struct FileIO {
	char				**pathRef;	/* SFGetFile2 pathRef handle.  NULL for no file. */
	char				**nameRef;	/* SFGetFile2 nameRef handle.					 */
	OpenRecGS			open;		/* Used to open the file.						 */
	RefNumRecGS			close;		/* Used to close the file.						 */
	NewlineRecGS		newline;	/* Use to set line read mode for file.			 */
	IORecGS				readWrite;	/* Use for reading and writing the file.		 */
	PositionRecGS		getPos;		/* Use for getting EOF and mark.				 */
	SetPositionRecGS	setPos;		/* Use for setting EOF and mark.				 */
} FileIO;

cextern char		line[256];		/* This is the buffer that text gets read into.	 */

cextern char		newlineChars[]
#ifdef __globals__
					= {0x0D, 0x8D, 0x00}	/* This are what terminate a line of text. */
#endif
;

cextern FileIO file
#ifdef __globals__
= {
	NULL,							/* No file has been chosen if NULL.				*/
	NULL,							/* 												*/

	{
		3,							/* pCount				We just need 3.			*/
		0,							/* refNum				To be filled in.		*/
		NULL,						/* pathname				To be filled in.		*/
		1,							/* requestAccess		Read-only file.			*/
		0, 							/* resourceNumber		Unused					*/
		0,							/* access				Unused					*/
		0,							/* fileType				Unused					*/
		0L,							/* auxType				Unused					*/
		0,							/* storageType			Unused					*/
		{0,0,0,0,0,0,0,0},			/* createDateTime		Unused					*/
		{0,0,0,0,0,0,0,0},			/* modDateTime			Unused					*/
		NULL,						/* optionList			Unused					*/
		0L,							/* eof					Unused					*/
		0L,							/* blocksUsed			Unused					*/
		0L,							/* resourceEOF			Unused					*/
		0L							/* resourceBlocks		Unused					*/
	},

	{
		1,							/* pCount				Close just needs 1.		*/
		0							/* refNum				To be filled in.		*/
	},

	{
		4,							/* pCount										*/
		0,							/* refNum				To be filled in.		*/
		0x7F,						/* enableMask			No hi-bits from file.	*/
		3,							/* numChars				# of EOL chars.			*/
		newlineChars 				/* newlineTable			Lines end with a c/r.	*/
	},

	{
		4,							/* pCount										*/
		0,							/* refNum				To be filled in.		*/
		line,						/* dataBuffer			Where to put the data.	*/
		255L,						/* requestCount			Max # of bytes to read.	*/
		0L, 						/* transferCount		# of bytes read.		*/
		0,							/* cachePriority		Unused					*/
	},

	{
		2,							/* pCount										*/
		0,							/* refNum				To be filled in.		*/
		0L,							/* position				For GetEOF & GetMark.	*/
	},

	{
		3,							/* pCount										*/
		0,							/* refNum				To be filled in.		*/
		0,							/* base					Which disp. for pos.	*/
		0L							/* displacement			For SetEOF & SetMark.	*/
	}
}
#endif
;
